/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import net.dries007.tfc.api.recipes.barrel.BarrelRecipe;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.compat.crafttweaker.CTHelper;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.terrafirmacraft.Barrel")
@ZenRegister
public class CTBarrel {
    @ZenMethod
    public static void addRecipe(String registryName, crafttweaker.api.item.IIngredient itemInput, ILiquidStack fluidInput, IItemStack itemOutput, ILiquidStack fluidOutput, int hours) {
        FluidStack outputFluid;
        if (itemOutput == null && fluidOutput == null) {
            throw new IllegalArgumentException("At least one output must be supplied");
        }
        if (fluidInput == null) {
            throw new IllegalArgumentException("Fluid input must be non-null");
        }
        if (itemInput instanceof ILiquidStack) {
            throw new IllegalArgumentException("There is a fluid where it's supposed to be an item!");
        }
        IIngredient itemIngredient = itemInput == null ? IIngredient.of(ItemStack.field_190927_a) : CTHelper.getInternalIngredient(itemInput);
        IIngredient fluidIngredient = CTHelper.getInternalIngredient((crafttweaker.api.item.IIngredient)fluidInput);
        ItemStack outputStack = itemOutput == null ? ItemStack.field_190927_a : (ItemStack)itemOutput.getInternal();
        FluidStack fluidStack = outputFluid = fluidOutput == null ? null : (FluidStack)fluidOutput.getInternal();
        if (outputFluid != null) {
            registryName = registryName + "_" + outputFluid.getUnlocalizedName();
        }
        final BarrelRecipe recipe = (BarrelRecipe)new BarrelRecipe(fluidIngredient, itemIngredient, outputFluid, outputStack, hours * 1000).setRegistryName(registryName);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                TFCRegistries.BARREL.register((IForgeRegistryEntry)recipe);
            }

            public String describe() {
                return "Adding barrel recipe " + recipe.getRegistryName().toString();
            }
        });
    }

    @ZenMethod
    public static void addRecipe(String registryName, ILiquidStack fluidInput, IItemStack itemOutput, ILiquidStack fluidOutput, int hours) {
        CTBarrel.addRecipe(registryName, null, fluidInput, itemOutput, fluidOutput, hours);
    }

    @ZenMethod
    public static void addRecipe(String registryName, ILiquidStack fluidInput, IItemStack itemOutput, int hours) {
        CTBarrel.addRecipe(registryName, null, fluidInput, itemOutput, null, hours);
    }

    @ZenMethod
    public static void addRecipe(String registryName, ILiquidStack fluidInput, ILiquidStack fluidOutput, int hours) {
        CTBarrel.addRecipe(registryName, null, fluidInput, null, fluidOutput, hours);
    }

    @ZenMethod
    public static void addRecipe(String registryName, crafttweaker.api.item.IIngredient itemInput, ILiquidStack fluidInput, IItemStack itemOutput, int hours) {
        CTBarrel.addRecipe(registryName, itemInput, fluidInput, itemOutput, null, hours);
    }

    @ZenMethod
    public static void addRecipe(String registryName, crafttweaker.api.item.IIngredient itemInput, ILiquidStack fluidInput, ILiquidStack fluidOutput, int hours) {
        CTBarrel.addRecipe(registryName, itemInput, fluidInput, null, fluidOutput, hours);
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack outputLiquid) {
        CTBarrel.removeRecipe(null, outputLiquid);
    }

    @ZenMethod
    public static void removeRecipe(IItemStack outputItem) {
        CTBarrel.removeRecipe(outputItem, null);
    }

    @ZenMethod
    public static void removeRecipe(IItemStack outputItem, ILiquidStack outputLiquid) {
        FluidStack fluid;
        ItemStack item = outputItem != null ? (ItemStack)outputItem.getInternal() : ItemStack.field_190927_a;
        FluidStack fluidStack = fluid = outputLiquid != null ? (FluidStack)outputLiquid.getInternal() : null;
        if (fluid == null && item == ItemStack.field_190927_a) {
            throw new IllegalArgumentException("At least one output must be supplied");
        }
        ArrayList removeList = new ArrayList();
        TFCRegistries.BARREL.getValuesCollection().stream().filter(x -> (x.getOutputStack() == item || x.getOutputStack().func_77969_a(item)) && (fluid == null && x.getOutputFluid() == null || fluid != null && fluid.isFluidEqual(x.getOutputFluid()))).forEach(removeList::add);
        for (final BarrelRecipe rem : removeList) {
            CraftTweakerAPI.apply((IAction)new IAction(){

                public void apply() {
                    IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)TFCRegistries.BARREL;
                    modRegistry.remove(rem.getRegistryName());
                }

                public String describe() {
                    return "Removing barrel recipe " + rem.getRegistryName().toString();
                }
            });
        }
    }

    @ZenMethod
    public static void removeRecipe(String registryName) {
        final BarrelRecipe recipe = (BarrelRecipe)TFCRegistries.BARREL.getValue(new ResourceLocation(registryName));
        if (recipe != null) {
            CraftTweakerAPI.apply((IAction)new IAction(){

                public void apply() {
                    IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)TFCRegistries.BARREL;
                    modRegistry.remove(recipe.getRegistryName());
                }

                public String describe() {
                    return "Removing barrel recipe " + recipe.getRegistryName().toString();
                }
            });
        }
    }
}

